<?php
/******************************************************************************
Etano
===============================================================================
File:                       includes/classes/fields/field_youtube.class.php
$Revision: 207 $
Software by:                DateMill (http://www.datemill.com)
Copyright by:               DateMill (http://www.datemill.com)
Support at:                 http://www.datemill.com/forum
*******************************************************************************
* See the "docs/licenses/etano.txt" file for license.                         *
******************************************************************************/


class field_youtube extends field_textfield {
	var $empty_value=array('edit'=>'','display'=>'','search'=>'');
	var $display_name='YouTube';
	var $whole_code='<style>.videoWrap iframe {position: absolute;top: 0;left: 0;width: 100%;height: 100%;}</style>
						<div class="videoWrap" style="position: relative;padding-bottom: 56.25%;padding-top: 25px;height: 0;">
						<iframe width="560" height="315" src="//www.youtube.com/embed/__PARAM1__?rel=0" frameborder="0" allowfullscreen></iframe>
					</div>';
	var $raw_url='https://www.youtube.com/watch?v=__PARAM1__';

	function __construct($config=array(),$is_search=false) {
		$this->config=$config;
		$this->is_search=$is_search;
		if (isset($this->config['default_value'])) {
			$this->value=$this->config['default_value'];
		} else {
			$this->value=$this->empty_value['edit'];
		}
	}

	function set_value(&$all_values,$sanitize=true) {
		$temp=isset($all_values[$this->config['dbfield']]) ? $all_values[$this->config['dbfield']] : '';
		if ($sanitize) {
			$m=array();
			if (preg_match('/youtu.be\/([A-Za-z0-9._%-]*)/',$temp,$m)) {
				$this->value=array($m[1]);
		} elseif (preg_match('/watch\?v=([A-Za-z0-9._%-]*)/',$temp,$m)) {
				$this->value=array($m[1]);		
        } elseif (preg_match('/youtube.com\/v\/([A-Za-z0-9._%-]*)/',$temp,$m)) { 
			$this->value=array($m[1]);	
			}
		} else {
			$this->value=$temp;
		}
		return true;
	}

	function edit($tabindex=1) {
		$vidVal="";
		$myreturn='<input type="text" name="'.$this->config['dbfield'].'" id="'.$this->config['dbfield'].'" tabindex="'.$tabindex.'"';
		if (!empty($this->value)) {
			if (is_string($this->value)) {
				$this->value=explode('|',$this->value);
			}
			$temp=str_replace(array('__PARAM1__'),$this->value,$this->raw_url);
			$vidVal=sanitize_and_format($temp,TYPE_STRING,$GLOBALS['__field2format'][TEXT_DB2EDIT]);
		}
		$myreturn.=' value="'.$vidVal.'" />';
		return $myreturn;
	}

	function display() {
		$myreturn='';
		if (!empty($this->value)) {
			if (is_string($this->value)) {
				$this->value=explode('|',$this->value);
			}
			$myreturn=str_replace(array('__PARAM1__'),$this->value,$this->whole_code);
		}
		return $myreturn;
	}

	function edit_admin() {
		return '';
	}

	function admin_processor() {
		return false;
	}

	function query_select() {
		return '`'.$this->config['dbfield'].'`';
	}

	function query_set() {
		// $this->value should be sanitized for DB if set_value() didn't sanitize the input.
		// This means that we should call this function only in an addedit processor!!!!
		$temp='';
		if (!empty($this->value)) {
			if (is_array($this->value)) {
				$temp=join('|',$this->value);
			}
		}
		return '`'.$this->config['dbfield']."`='".$temp."'";
	}

	function query_search() {
		return '';
	}

	function edit_js() {
		$myreturn='';
		return $myreturn;
	}

	function validation_server() {
		$myreturn=true;
		return $myreturn;
	}

	function get_value($as_array=false) {
		if ($as_array) {
			return array($this->config['dbfield']=>$this->value);
		} else {
			return $this->value;
		}
	}
}

if (defined('IN_ADMIN')) {
	$GLOBALS['accepted_fieldtype']['direct']['field_youtube']='YouTube';
}
