<?php
/******************************************************************************
Etano
===============================================================================
File:                       includes/classes/fields/field_link.class.php
$Revision: 207 $
Software by:                DateMill (http://www.datemill.com)
Copyright by:               DateMill (http://www.datemill.com)
Support at:                 http://www.datemill.com/forum
*******************************************************************************
* See the "docs/licenses/etano.txt" file for license.                         *
******************************************************************************/


class field_link extends iprofile_field {
	var $empty_value=array('edit'=>'','display'=>'','search'=>'');
	var $display_name='Link Field';

	function __construct($config=array(),$is_search=false) {
		$this->config=$config;
		$this->is_search=$is_search;
		if (isset($this->config['default_value'])) {
			$this->value=$this->config['default_value'];
		} else {
			$this->value=$this->empty_value['edit'];
		}
	}

	function set_value(&$all_values,$sanitize=true) {
		if ($sanitize) {
			$this->value=sanitize_and_format_gpc($all_values,$this->config['dbfield'],TYPE_STRING,$GLOBALS['__field2format'][FIELD_TEXTFIELD],$this->empty_value['edit']);
		} elseif (isset($all_values[$this->config['dbfield']])) {
			$this->value=$all_values[$this->config['dbfield']];
		}
		return true;
	}

	function edit($tabindex=1) {
		return '<input type="text" class="text" name="'.$this->config['dbfield'].'" id="'.$this->config['dbfield'].'" tabindex="'.$tabindex.'" value="'.sanitize_and_format($this->value,TYPE_STRING,$GLOBALS['__field2format'][TEXT_DB2EDIT]).'" />';
	}

	function display() {
		$myreturn='';
//		$value=sanitize_and_format($this->value,TYPE_STRING,$GLOBALS['__field2format'][TEXT_DB2DISPLAY]);
		if (!empty($this->value)) {
			$myreturn.='<a';
			if (!empty($this->config['external_link']) || !empty($this->config['no_follow'])) {
				$myreturn.=' rel*="';
				if (!empty($this->config['external_link'])) {
					$myreturn.='external ';
				}
				if (!empty($this->config['no_follow'])) {
					$myreturn.='no_follow ';
				}
				$myreturn=substr($myreturn,0,-1).'"';
			}
			$myreturn.=' class="content-link simple field_link" href="'.$this->value.'">'.$this->value.'</a>';
		}
		return $myreturn;
	}

	function edit_admin() {
		global $output,$__field2format;
		$myreturn='';
		if (isset($output['external_link'])) {
			if (!empty($output['external_link'])) {
				$output['external_link']='checked="checked"';
			}
		} else {
			$output['external_link']='checked="checked"';
		}
		if (isset($output['no_follow'])) {
			if (!empty($output['no_follow'])) {
				$output['no_follow']='checked="checked"';
			}
		} else {
			$output['no_follow']='checked="checked"';
		}
		$myreturn.='<div class="clear">
			<label for="external_link">Open link in new window?</label>
			<input type="checkbox" class="checkbox" name="external_link" id="external_link" value="1" '.$output['external_link'].' />
		</div>';
		$myreturn.='<div class="clear">
			<label for="no_follow">Use no_follow?</label>
			<input type="checkbox" class="checkbox" name="no_follow" id="no_follow" value="1" '.$output['no_follow'].' />
		</div>';
		return $myreturn;
	}

	function admin_processor() {
		$error=false;
		$my_input=array();
		global $input,$__field2format,$dbtable_prefix,$default_skin_code;
		$my_input['external_link']=sanitize_and_format_gpc($_POST,'external_link',TYPE_INT,0,0);
		$my_input['no_follow']=sanitize_and_format_gpc($_POST,'no_follow',TYPE_INT,0,0);
		$input['custom_config']=sanitize_and_format(serialize($my_input),TYPE_STRING,FORMAT_ADDSLASH);
		return $error;
	}

	function query_select() {
		return '`'.$this->config['dbfield'].'`';
	}

	function query_set() {
		// $this->value should be sanitized for DB if set_value() didn't sanitize the input.
		// This means that we should call this function only in an addedit processor!!!!
		return '`'.$this->config['dbfield']."`='".$this->value."'";
	}

	function query_search() {
		return '';
	}

	function query_create($dbfield) {
		return " ADD `{$dbfield}` varchar(256) not null default ''";
	}

	function query_drop($dbfield) {
		return " DROP `{$dbfield}`";
	}

	function edit_js() {
		$myreturn='';
		$myreturn.='$(\'#'.$this->config['dbfield'].'\').parents(\'form\').bind(\'submit\',function() {';
		if (!empty($this->config['required'])) {
			$myreturn.='if ($(\'#'.$this->config['dbfield'].'\',this).val()==\''.$this->empty_value['edit'].'\') {
					alert(\''.$this->config['label'].' cannot be empty\');
					$(\'#'.$this->config['dbfield'].'\',this).focus();
					return false;
				}';
		}
		$myreturn.='if ($(\'#'.$this->config['dbfield'].'\',this).val()!=\'\' && $(\'#'.$this->config['dbfield'].'\',this).val().substr(0,7)!=\'http://\')
		if ($(\'#'.$this->config['dbfield'].'\',this).val()!=\'\' && $(\'#'.$this->config['dbfield'].'\',this).val().substr(0,8)!=\'https://\') {
				alert(\'Please enter a link starting with http://\ or https://\');
				$(\'#'.$this->config['dbfield'].'\',this).focus();
				return false;
			}
			if ($(\'#'.$this->config['dbfield'].'\',this).val().indexOf(\'<\')!=-1 || $(\'#'.$this->config['dbfield'].'\',this).val().indexOf(\'>\')!=-1 ) {
				alert(\'Invalid characters in '.$this->config['label'].'\');
				$(\'#'.$this->config['dbfield'].'\',this).focus();
				return false;
			}
			if ($(\'#'.$this->config['dbfield'].'\',this).val()==\'http([s]?)://\') {
				alert(\'Invalid link entered\');
				$(\'#'.$this->config['dbfield'].'\',this).focus();
				return false;
			}';
		$myreturn.='})';
		return $myreturn;
	}

	function validation_server() {
		$myreturn=true;
		if (!empty($this->config['required']) && $this->value==$this->empty_value['edit']) {
			$myreturn=false;
		}
		if (!empty($this->value) && substr($this->value,0,7)!='http://' && substr($this->value,0,8)!='https://') {
			$myreturn=false;
		}
		if (strpos($this->value,'<')!==false || strpos($this->value,'>')!==false) {
			$myreturn=false;
		}
		return $myreturn;
	}

	function get_value($as_array=false) {
		if ($as_array) {
			return array($this->config['dbfield']=>$this->value);
		} else {
			return $this->value;
		}
	}
}

if (defined('IN_ADMIN')) {
	$GLOBALS['accepted_fieldtype']['direct']['field_link']='Link Field';
}
